/// @file syslogLogger.h
///
/// @brief Describes the syslog logger
///
/// @component Uspi/DeviceDetector
///
/// @author F.Berat / ADITG/SWG / fberat@de.adit-jv.com
///
/// @copyright (c) 2016 Advanced Driver Information Technology.
/// This code is developed by Advanced Driver Information Technology.
/// Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
/// All rights reserved.
///
/// @see Log DltLogger

#include <iostream>
#include <string>
#include <sys/syslog.h>

#ifndef __SYSLOG_LOGGER_H__
#define __SYSLOG_LOGGER_H__

#include "logger.h"

namespace adit {
namespace uspi {

/// @brief The syslog log class
///
/// This class allows to use syslog as a standard ostream output.
class SysLog : public Log {
    public:
        /// SysLog constructor
        explicit SysLog(const char *ident = LOGGER_IDENTITY);

    protected:
        /// Flushes the @ref mBuffer to syslog if non-empty
        int sync();
        /// Add a character to the buffer and sync if EOF is met.
        int overflow(int c);
};

} // namespace uspi
} // namespace adit
#endif // __SYSLOG_LOGGER_H__
